<?php defined( 'ABSPATH' ) || die( 'No direct access allowed' );

add_action(
	'admin_menu',
	function () {
		add_menu_page(
			'Make',
			'Make',
			'manage_options',
			'integromat',
			function () {
				if ( ! current_user_can( 'manage_options' ) ) {
					return;
				}
				settings_errors( 'integromat_api_messages' );

				include_once __DIR__ . '/template/general_menu.phtml';
			},
			'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/Pgo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDIwMDEwOTA0Ly9FTiIKICJodHRwOi8vd3d3LnczLm9yZy9UUi8yMDAxL1JFQy1TVkctMjAwMTA5MDQvRFREL3N2ZzEwLmR0ZCI+CjxzdmcgdmVyc2lvbj0iMS4wIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiB3aWR0aD0iNTEyLjAwMDAwMHB0IiBoZWlnaHQ9IjUxMi4wMDAwMDBwdCIgdmlld0JveD0iMCAwIDUxMi4wMDAwMDAgNTEyLjAwMDAwMCIKIHByZXNlcnZlQXNwZWN0UmF0aW89InhNaWRZTWlkIG1lZXQiPgoKPGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMC4wMDAwMDAsNTEyLjAwMDAwMCkgc2NhbGUoMC4xMDAwMDAsLTAuMTAwMDAwKSIKZmlsbD0iIzAwMDAwMCIgc3Ryb2tlPSJub25lIj4KPHBhdGggZD0iTTAgMjU2MCBsMCAtMjU2MCAyNTYwIDAgMjU2MCAwIDAgMjU2MCAwIDI1NjAgLTI1NjAgMCAtMjU2MCAwIDAKLTI1NjB6IG0yNzkwIDEwMDUgYzI2OSAtNTQgMzAzIC02NSAzMTQgLTEwNCAzIC05IC03OSAtNDQ1IC0xODMgLTk2OSAtMTQwCi03MDkgLTE5MyAtOTU3IC0yMDYgLTk3MiAtMTAgLTExIC0zMCAtMjAgLTQ0IC0yMCAtNDcgMCAtNTM2IDEwMSAtNTU4IDExNgotMTMgOCAtMjUgMjQgLTI4IDM3IC0zIDEyIDgwIDQ1MSAxODMgOTc2IDE3MCA4NTYgMTkxIDk1NiAyMTIgOTczIDEyIDEwIDI1CjE4IDI5IDE4IDQgMCAxMzAgLTI1IDI4MSAtNTV6IG0tNzIzIC04OSBjMjIwIC0xMTAgMjYzIC0xMzggMjYzIC0xNzYgMCAtMjQKLTg3MCAtMTc1MyAtODkyIC0xNzcyIC0xMSAtMTAgLTMwIC0xOCAtNDIgLTE4IC0yMyAwIC00ODcgMjMxIC01MTggMjU4IC0xMCA4Ci0xOCAyOSAtMTggNDUgMCAyMCAxNTAgMzI4IDQzNiA4OTYgMjQwIDQ3NiA0NDAgODcxIDQ0NiA4NzggMTIgMTUgNDcgMjEgNzQKMTIgMTEgLTQgMTI0IC01OSAyNTEgLTEyM3ogbTE3NTggODkgbDI1IC0yNCAwIC05NzUgYzAgLTY5MyAtMyAtOTgyIC0xMSAtOTk5Ci0yMCAtNDQgLTQ0IC00NyAtMzI1IC00NyAtMjg2IDAgLTMxNSA1IC0zMjggNTIgLTMgMTMgLTYgNDYxIC02IDk5NiBsMCA5NzMKMjUgMjQgMjQgMjUgMjg2IDAgMjg2IDAgMjQgLTI1eiIvPgo8L2c+Cjwvc3ZnPg=='
			// 'data:image/svg+xml;base64,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'
		);

		// REST API Custom Fields settings page.
		add_submenu_page(
			'integromat',
			'Custom API Fields',
			'Custom API Fields',
			'manage_options',
			IWC_MENUITEM_IDENTIFIER,
			function () {
				if ( ! current_user_can( 'manage_options' ) ) {
					return;
				}
				settings_errors( 'integromat_api_messages' );
				include_once __DIR__ . '/template/customFields.phtml';
			}
		);

		add_submenu_page(
			'integromat',
			'Custom Taxonomies',
			'Custom Taxonomies',
			'manage_options',
			'integromat_custom_toxonomies',
			function () {
				if ( ! current_user_can( 'manage_options' ) ) {
					return;
				}
				settings_errors( 'integromat_api_messages' );
				include_once __DIR__ . '/template/custom_taxonomies.phtml';
			}
		);
	}
);
